/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.structures.piece;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.util.GlobalState;
import org.betterx.betterend.world.structures.piece.BasePiece;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class CavePiece
extends BasePiece {
    private OpenSimplexNoise noise;
    private BlockPos center;
    private float radius;

    public CavePiece(BlockPos center, float radius, int id) {
        super(EndStructures.CAVE_PIECE, id, null);
        this.center = center;
        this.radius = radius;
        this.noise = new OpenSimplexNoise(MHelper.getSeed((int)534, (int)center.m_123341_(), (int)center.m_123343_()));
        this.makeBoundingBox();
    }

    public CavePiece(StructurePieceSerializationContext type, CompoundTag tag) {
        super(EndStructures.CAVE_PIECE, tag);
        this.makeBoundingBox();
    }

    public void m_213694_(WorldGenLevel world, StructureManager arg, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox blockBox, ChunkPos chunkPos, BlockPos blockPos) {
        int x1 = MHelper.max((int)this.f_73383_.m_162395_(), (int)blockBox.m_162395_());
        int z1 = MHelper.max((int)this.f_73383_.m_162398_(), (int)blockBox.m_162398_());
        int x2 = MHelper.min((int)this.f_73383_.m_162399_(), (int)blockBox.m_162399_());
        int z2 = MHelper.min((int)this.f_73383_.m_162401_(), (int)blockBox.m_162401_());
        int y1 = this.f_73383_.m_162396_();
        int y2 = this.f_73383_.m_162400_();
        double hr = (double)this.radius * 0.75;
        double nr = (double)this.radius * 0.25;
        BlockPos.MutableBlockPos pos = GlobalState.stateForThread().POS;
        for (int x = x1; x <= x2; ++x) {
            int xsq = x - this.center.m_123341_();
            xsq *= xsq;
            pos.m_142451_(x);
            for (int z = z1; z <= z2; ++z) {
                int zsq = z - this.center.m_123343_();
                zsq *= zsq;
                pos.m_142443_(z);
                for (int y = y1; y <= y2; ++y) {
                    int ysq = y - this.center.m_123342_();
                    ysq = (int)((double)ysq * 1.6);
                    ysq *= ysq;
                    pos.m_142448_(y);
                    double r = this.noise.eval((double)x * 0.1, (double)y * 0.1, (double)z * 0.1) * nr + hr;
                    double r2 = r - 4.5;
                    double dist = xsq + ysq + zsq;
                    if (dist < r2 * r2) {
                        if (!world.m_8055_((BlockPos)pos).m_204336_(CommonBlockTags.END_STONES)) continue;
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)f_73382_);
                        continue;
                    }
                    if (!(dist < r * r) || !world.m_8055_((BlockPos)pos).m_247087_()) continue;
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (Block)Blocks.f_50259_);
                }
            }
        }
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.m_128365_("center", (Tag)NbtUtils.m_129224_((BlockPos)this.center));
        tag.m_128350_("radius", this.radius);
    }

    @Override
    protected void fromNbt(CompoundTag tag) {
        this.center = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("center"));
        this.radius = tag.m_128457_("radius");
        this.noise = new OpenSimplexNoise(MHelper.getSeed((int)534, (int)this.center.m_123341_(), (int)this.center.m_123343_()));
    }

    private void makeBoundingBox() {
        int minX = MHelper.floor((double)((float)this.center.m_123341_() - this.radius));
        int minY = MHelper.floor((double)((float)this.center.m_123342_() - this.radius));
        int minZ = MHelper.floor((double)((float)this.center.m_123343_() - this.radius));
        int maxX = MHelper.floor((double)((float)this.center.m_123341_() + this.radius + 1.0f));
        int maxY = MHelper.floor((double)((float)this.center.m_123342_() + this.radius + 1.0f));
        int maxZ = MHelper.floor((double)((float)this.center.m_123343_() + this.radius + 1.0f));
        this.f_73383_ = new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

